turtles-own [man? woman? happy?]
patches-own [men women people]
globals [boring-groups moves number-happy group-sites]

to setup
  ca
  set group-sites patches with [group-site?]
  set-default-shape turtles "person"
  cct number [
    set size 3  ;; makes them easier to see
    ;;blue represents male, pink represents female. No stereotypes are meant
    ;;to be promoted. Simply change the colors right here if you'd like.
    ifelse (random 2 = 0)
       [set man? true set woman? false set color blue] 
       [set man? false set woman? true set color pink]
    ifelse (random 2 = 0) [set heading 90] [set heading 270] ;; randomly face right or left
    set ycor 0
    set xcor random screen-size-x ]
  ask turtles
    [move-into-groups]
  setup-patches
  setup-plots
  set moves 0
  update-labels
  spread-people 
  update-plots
end

to setup-patches
  ask patches [
    set men 0
    set women 0
    set people 0]
  ask turtles [
    if man? [set men (men + 1)]
    if woman? [set women (women + 1)]]
  ask patches [
    set people (men + women)]
  update-happiness
  update-boring-groups
end

to go
  if (number-happy = number)
  [
    stop   ;; stop the simulation if everyone is happy
  ] 
  group-people ;; put all people on the x-axis
  update-happiness
  move-if-unhappy  
  update-boring-groups
  update-labels
  spread-people ;; move the people into vertical columns
  set moves (moves + 1)
  update-plots
  if limit-speed?
    [ wait 0.75 ] ;; keep the spread groups on the screen for a bit
end

to update-labels
  ask group-sites
    [ set plabel count turtles-here ]
end

to update-happiness
  ask patches [
    set people (men + women)]
  ask turtles [   ;;; you are happy if the proportion of people of the opposite sex does not exceed your tolerance
    if man? [ifelse (women / people) > (tolerance / 100)
              [set happy? false]
              [set happy? true]]
    if woman? [ifelse (men / people) > (tolerance / 100)
            [set happy? false]
            [set happy? true]]
   ;; if (happy? = true) [set num-happy (num-happy + 1)]
   ] 
  set number-happy count turtles with [happy?]  ;; update number-happy variable
end

to move-if-unhappy
  ask turtles [
    if (not happy?)
      [ifelse man? [set men men - 1]   ;;decrease the count in your old group
                   [set women women - 1]
       ifelse (random 2 = 0) [set heading 90] [set heading 270] ;; randomly face right or left
       fd 1  ;; move out of your group
       move-into-groups
       ifelse man? [set men men + 1] [set women women + 1]]] ;;increase the count in your new in group
end

to move-into-groups  ;;turtle procedure
  ; move forward until you hit the closest group
 if not group-site?
   [ fd 1
     if limit-speed?
       [ wait 0.1 ] ;; slow it down so user can see it happening
     move-into-groups]
end

to-report group-site?  ;; turtle or patch procedure
  ;; if your pycor is 0 and your pxcor is where a group should be located,
  ;; then you're a group site (patch) or on a group site (turtle).
  ;; first figure out how many patches apart the groups will be
  let group-interval floor (screen-size-x / num-groups)
  report
    ;; first check pycor
    (pycor = 0) and
    ;; then check if the distance between groups divides evenly into
    ;; our distance from the right hand edge of the screen
    (((screen-edge-x - pxcor) mod group-interval) = 0) and
    ;; finally, make sure we don't wind up with more groups than
    ;; the user asked for
    (floor ((screen-edge-x - pxcor) / group-interval) < num-groups)
end

to update-boring-groups
  ask group-sites [
    set plabel-color white
    if people > 0
      [if ((men = 0) or (women = 0)) [set plabel-color gray]]]
  set boring-groups (count group-sites with [plabel-color = gray])
end

to setup-plots
  set-current-plot "Happy Partygoers"
  set-plot-y-range 0 number
end

to update-plots
  set-current-plot "Happy Partygoers"
  set-current-plot-pen "Happy"
  plot (count turtles with [happy?]) 
  set-current-plot "Single Sex Groups"
  plot boring-groups
end

;; spread people out vertically 
to spread-people
  ask turtles [ifelse man?
                [set heading 0 fd 2]
                [set heading 180 fd 2]
  jump count other-turtles-here] ;; this trick works because of the serial ordering of turtle execution
end
  
;; pile people up on the x-axis                           
to group-people
  ask turtles [set ycor 0]
end


; *** NetLogo Model Copyright Notice ***
;
; This model was created as part of the project: CONNECTED MATHEMATICS:
; MAKING SENSE OF COMPLEX PHENOMENA THROUGH BUILDING OBJECT-BASED PARALLEL
; MODELS (OBPML).  The project gratefully acknowledges the support of the
; National Science Foundation (Applications of Advanced Technologies
; Program) -- grant numbers RED #9552950 and REC #9632612.
;
; Copyright 1997 by Uri Wilensky. All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; This model was converted to NetLogo as part of the project:
; PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING IN
; CLASSROOMS.  The project gratefully acknowledges the support of the
; National Science Foundation (REPP program) -- grant number REC #9814682.
; Converted from StarLogoT to NetLogo, 2001.  Updated 2002.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. (1997).  NetLogo Party model.
; http://ccl.northwestern.edu/netlogo/models/Party.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 1998 by Uri Wilensky.  All rights reserved.  See
; http://ccl.northwestern.edu/netlogo/models/Party
; for terms of use.
;
; *** End of NetLogo Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
204
10
538
485
40
55
4.0
1
14
1
1
1
0

CC-WINDOW
5
499
793
594
Command Center

BUTTON
7
10
75
43
setup
setup
NIL
1
T
OBSERVER
T
NIL

BUTTON
7
47
75
80
go
go
T
1
T
OBSERVER
T
NIL

BUTTON
7
84
75
117
step-once
go
NIL
1
T
OBSERVER
T
NIL

MONITOR
7
215
63
264
moves
moves
0
1

SLIDER
77
10
200
43
tolerance
tolerance
0.0
99.0
25.0
1.0
1
%

SLIDER
77
47
200
80
number
number
0
300
75
1
1
NIL

MONITOR
69
215
173
264
number-happy
number-happy
0
1

MONITOR
24
266
142
315
single-sex-groups
boring-groups
0
1

PLOT
541
10
784
250
Happy Partygoers
moves
number
0.0
10.0
0.0
150.0
true
false
PENS
"Happy" 1.0 0 -11352576 true

PLOT
541
252
784
454
Single Sex Groups
moves
seg-groups
0.0
10.0
0.0
12.0
true
false
PENS
"Single Sex" 1.0 0 -65536 true

SLIDER
77
84
200
117
num-groups
num-groups
5
20
10
1
1
NIL

SWITCH
35
150
168
183
limit-speed?
limit-speed?
0
1
-1000

@#$#@#$#@
WHAT IS IT?
-----------
This program models a cocktail party.  The party is made up of groups of both men and women.  The partygoers have a TOLERANCE that defines their comfort level with a group that has members of the opposite sex.  If they are in a group that has a higher percentage of people of the opposite sex than their TOLERANCE allows, then they are considered "uncomfortable", and they leave that group to find another group.  This action continues until everyone at the party is "comfortable" within their group.

This model is based on the work of the pioneering economist Thomas Schelling. It is also described in: Resnick, M. & Wilensky, U. (1998). Diving into Complexity: Developing Probabilistic Decentralized Thinking through Role-Playing Activities. Journal of Learning Sciences, Vol. 7, No. 2. http://ccl.northwestern.edu/cm/papers/starpeople/


HOW TO USE IT
-------------
To set the number of people at the party, use the NUMBER slider. 

To set the number of initial groups, use the NUM-GROUPS slider.

To set the tolerance of the people for the opposite sex, use the TOLERANCE slider.  If the TOLERANCE slider is set to 75, then each person will tolerate being in a group with less than or equal to 75% people of the opposite sex.  If there are more than this, the person is uncomfortable, and he/she leaves the group and tries out an adjacent group.

The SETUP button sets up all the people into random groups.  The GO button sets the party in motion. You can use the STEP-ONCE button to make all uncomfortable partygoers move once.  The MOVES monitor shows the number of times people move from their groups. The NUMBER-HAPPY monitor shows how many people are content and this value is dynamically graphed in the "happy partygoers" plot. The counts are shown in gray for "single-sex" groups, white for mixed groups.  The simulation ends when everyone is happy.  The SINGLE-SEX-GROUPS monitor shows the number of single-sex groups and this value is dynamically plotted in the "single sex groups" plot.


RUNNING the MODEL
-----------------

THINGS TO NOTICE
----------------
At the end of the simulation (when everyone is happy), notice the number of single-sex groups.  Is there an increase from their initial compositions?

Is there a critical tolerance at which each group ends up being a single-sex group?

Notice the difference in time it takes for all groups to be comfortable depending upon the tolerance.


THINGS TO TRY
-------------
See how many mixed groups (not a single-sex group) you can get.
  
Use the STEP-ONCE button, and experiment with different tolerances.  Watch how one unhappy person can disrupt the stability of other groups.

Is it possible to have an initial grouping such that the party is never completely content? (i.e. the model never terminates)

Observe real parties. Is this model descriptive of real social settings?  What tolerances would model the people in the real party?


EXTENDING THE MODEL
-------------------
Add another dimension to the model.  Instead of male/female, try a trait that has more than two types, like race or religion. You can use BREEDS to implement that.

Allow each BREED of person to have their own tolerance.

Complicate the tolerance rules: For example, the tolerance could go up as long as there are at least 2 of one BREED.

Allow groups to subdivide, instead of finding new groups.

Set a maximum group size, so that if there are too many people in the group, they become unhappy.


NETLOGO FEATURES
-----------------
Notice the use of the "mod" function with a portion of the "screen-size" to space out the groups evenly. Setting up the groups in this manner allows for easy movement from group to group.

Note also the use of the seriality of turtle execution for spreading out the turtles. Knowing that lower numbered turtles execute first enables this code to align the labels in the SHOW-COUNTS option.


RELATED MODELS
---------------
Segregation


CREDITS AND REFERENCES
----------------------
Schelling, T. (1978). Micro-motives and Macro-Behavior. New York: Norton. 

Resnick, M. & Wilensky, U. (1998). Diving into Complexity: Developing Probabilistic Decentralized Thinking through Role-Playing Activities. Journal of Learning Sciences, Vol. 7, No. 2.

To refer to this model in academic publications, please use: Wilensky, U. (1997).  NetLogo Party model. http://ccl.northwestern.edu/netlogo/models/Party. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

In other publications, please use: Copyright 1997 by Uri Wilensky.  All rights reserved.  See http://ccl.northwestern.edu/netlogo/models/Party for terms of use.
@#$#@#$#@
default
true
0
Polygon -7566196 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7566196 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7566196 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7566196 true true 150 285 285 225 285 75 150 135
Polygon -7566196 true true 150 135 15 75 150 15 285 75
Polygon -7566196 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7566196 true true 96 182 108
Circle -7566196 true true 110 127 80
Circle -7566196 true true 110 75 80
Line -7566196 true 150 100 80 30
Line -7566196 true 150 100 220 30

butterfly
true
0
Polygon -7566196 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7566196 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7566196 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7566196 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7566196 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7566196 true true 47 195 58
Circle -7566196 true true 195 195 58

circle
false
0
Circle -7566196 true true 30 30 240

circle 2
false
0
Circle -7566196 true true 16 16 270
Circle -16777216 true false 46 46 210

cow
false
0
Polygon -7566196 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7566196 true true 73 210 86 251 62 249 48 208
Polygon -7566196 true true 25 114 16 195 9 204 23 213 25 200 39 123

face happy
false
0
Circle -7566196 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7566196 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7566196 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7566196 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7566196 true true 60 15 75 300
Polygon -7566196 true true 90 150 270 90 90 30
Line -7566196 true 75 135 90 135
Line -7566196 true 75 45 90 45

flower
false
0
Polygon -11352576 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7566196 true true 85 132 38
Circle -7566196 true true 130 147 38
Circle -7566196 true true 192 85 38
Circle -7566196 true true 85 40 38
Circle -7566196 true true 177 40 38
Circle -7566196 true true 177 132 38
Circle -7566196 true true 70 85 38
Circle -7566196 true true 130 25 38
Circle -7566196 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -11352576 true false 189 233 219 188 249 173 279 188 234 218
Polygon -11352576 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7566196 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7566196 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7566196 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7566196 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7566196 true 150 0 150 300

pentagon
false
0
Polygon -7566196 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7566196 true true 110 5 80
Polygon -7566196 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7566196 true true 127 79 172 94
Polygon -7566196 true true 195 90 240 150 225 180 165 105
Polygon -7566196 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7566196 true true 135 90 165 300
Polygon -7566196 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7566196 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7566196 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7566196 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7566196 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7566196 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7566196 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7566196 true true 30 30 270 270

square 2
false
0
Rectangle -7566196 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7566196 true true 60 270 150 0 240 270 15 105 285 105
Polygon -7566196 true true 75 120 105 210 195 210 225 120 150 75

target
false
0
Circle -7566196 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7566196 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7566196 true true 120 120 60

tree
false
0
Circle -7566196 true true 118 3 94
Rectangle -6524078 true false 120 195 180 300
Circle -7566196 true true 65 21 108
Circle -7566196 true true 116 41 127
Circle -7566196 true true 45 90 120
Circle -7566196 true true 104 74 152

triangle
false
0
Polygon -7566196 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7566196 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7566196 true true 4 45 195 187
Polygon -7566196 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7566196 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7566196 false true 24 174 42
Circle -7566196 false true 144 174 42
Circle -7566196 false true 234 174 42

turtle
true
0
Polygon -11352576 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -11352576 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -11352576 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -11352576 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -11352576 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7566196 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7566196 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7566196 true 150 285 150 15
Line -7566196 true 15 150 285 150
Circle -7566196 true true 120 120 60
Line -7566196 true 216 40 79 269
Line -7566196 true 40 84 269 221
Line -7566196 true 40 216 269 79
Line -7566196 true 84 40 221 269

x
false
0
Polygon -7566196 true true 270 75 225 30 30 225 75 270
Polygon -7566196 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 2.1beta4
@#$#@#$#@
set limit-speed? false
setup
repeat 20 [ go ]
@#$#@#$#@
@#$#@#$#@
